import React from 'react';
import { Table, Button, Spin } from 'antd';
import { Tour } from '../types';

interface TourListProps {
    tours: Tour[];
    loading: boolean;
    onReserve: (tour: Tour) => void;
}

const TourList: React.FC<TourListProps> = ({ tours, loading, onReserve }) => {
    const columns = [
        {
            title: 'Заглавие',
            dataIndex: 'title',
            key: 'title',
        },
        {
            title: 'Описание',
            dataIndex: 'body',
            key: 'body',
        },
        {
            title: 'Действия',
            key: 'action',
            render: (record: Tour) => (
                <Button onClick={() => onReserve(record)} type="primary">
                    Резервирай
                </Button>
            ),
        },
    ];

    return (
        <React.Fragment>
            {loading ? (
                <Spin size="large" />
            ) : (
                <Table
                    dataSource={tours}
                    columns={columns}
                    rowKey="id"
                    pagination={{ pageSize: 5 }}
                />
            )}
        </React.Fragment>
    );
};

export default TourList;